﻿namespace Microsoft.Samples.PlanMyNight.Entities
{
    using System.Runtime.Serialization;
    using System.Web.Routing;

    public enum SortCriteria
    {
        Relevance = 0,
        Popularity = 1,
        Rating = 2,
        Distance = 3,
    }

    public enum SearchType
    {
        Activity = 0,
        Itinerary = 1,
        ActivityItinerary = 2
    }

    [DataContract]
    public abstract class BaseSearchQuery
    {
        [DataMember]
        public SortCriteria SortBy { get; set; }

        [DataMember]
        public int Page { get; set; }

        [DataMember]
        public int PageSize { get; set; }

        [DataMember]
        public SearchType Type { get; set; }

        public abstract BaseSearchQuery NewPage(int page);

        public abstract BaseSearchQuery NewSortCriteria(SortCriteria sort);

        public abstract BaseSearchQuery NewType(SearchType type);

        public abstract RouteValueDictionary GetRouteValues();
    }
}
